<?php
header('Content-Type: application/json'); // Respuesta en JSON
header("Access-Control-Allow-Origin: *"); // Permitir acceso desde cualquier origen
header("Access-Control-Allow-Methods: GET, POST"); // Permitir métodos GET y POST
header("Access-Control-Allow-Headers: Content-Type");

// Datos de conexión a la base de datos
include 'config/bd.php';

// Archivo de log
$logFile = 'log.txt';

// Función para registrar logs
function writeLog($message) {
    global $logFile;
    file_put_contents($logFile, date("[Y-m-d H:i:s]") . " " . $message . PHP_EOL, FILE_APPEND);
}

// Intentar conexión a la base de datos
try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    writeLog("✅ Conexión exitosa a la base de datos.");
} catch (PDOException $e) {
    writeLog("❌ Error en la conexión: " . $e->getMessage());
    die(json_encode(["success" => false, "message" => "Error en la conexión a la base de datos."]));
}

date_default_timezone_set('America/Lima'); // Establecer zona horaria

$response = ["success" => false, "message" => ""];

// **1️⃣ Método POST - Guardar datos**
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    writeLog("📥 Recibida solicitud POST: " . json_encode($_POST));

    if (isset($_POST['transaction_name'], $_POST['package_name'], $_POST['amount'])) {
        $transactionName = trim($_POST['transaction_name']);
        $packageName = trim($_POST['package_name']);
        $amount = trim($_POST['amount']);
        $dateTime = date("Y-m-d H:i:s");

        try {
            $stmt = $pdo->prepare("INSERT INTO transactions (transaction_name, package_name, amount, date_time) VALUES (?, ?, ?, ?)");
            $stmt->execute([$transactionName, $packageName, $amount, $dateTime]);

            $response["success"] = true;
            $response["message"] = "✅ Transacción almacenada correctamente.";
        } catch (PDOException $e) {
            writeLog("❌ Error al insertar en la base de datos: " . $e->getMessage());
            $response["message"] = "Error al guardar la transacción.";
        }
    } else {
        $response["message"] = "⚠️ Datos incompletos.";
    }
}

// **2️⃣ Método GET - Obtener todas las transacciones**
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    writeLog("📤 Recibida solicitud GET.");

    try {
        $stmt = $pdo->query("SELECT id, transaction_name, package_name, amount, date_time FROM transactions ORDER BY date_time DESC");
        $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $response["success"] = true;
        $response["message"] = "✅ Datos obtenidos correctamente.";
        $response["transactions"] = $transactions;
    } catch (PDOException $e) {
        writeLog("❌ Error al obtener datos: " . $e->getMessage());
        $response["message"] = "Error al obtener los datos.";
    }
}

// **Registrar la solicitud en el archivo de log**
writeLog("📋 Respuesta enviada: " . json_encode($response));

echo json_encode($response);
?>
