<?php
// Datos de conexión a la base de datos
include '../config/bd.php';

// Verificar si se recibió el parámetro 'id'
if (isset($_GET['id'])) {
    $id = $_GET['id'];

    try {
        // Conexión a la base de datos
        $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Eliminar el registro de la tabla instalaciones
        $stmt = $pdo->prepare("DELETE FROM transactions WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            // Redirigir de vuelta a la página de listado
            header("Location: index.php?mensaje=Registro eliminado con éxito");
            exit;
        } else {
            echo "Error al eliminar el registro.";
        }
    } catch (PDOException $e) {
        echo "Error en la base de datos: " . $e->getMessage();
    }
} else {
    echo "ID no especificado.";
}
?>
