<?php
// Configuración de la conexión a la base de datos
include '../config/bd.php';
try {
    // Crear conexión PDO
    $conn = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Obtener datos desde ManyChat
    $dni = $_POST['dni'];
    $nombre_completo = $_POST['nombre_completo'];
    $direccion = $_POST['direccion'];
    $plan = $_POST['plan'];

    // Consulta SQL para insertar datos
    $sql = "INSERT INTO instalaciones (dni, nombre_completo, direccion, plan) 
            VALUES (:dni, :nombre_completo, :direccion, :plan)";

    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':dni', $dni);
    $stmt->bindParam(':nombre_completo', $nombre_completo);
    $stmt->bindParam(':direccion', $direccion);
    $stmt->bindParam(':plan', $plan);

    // Ejecutar la consulta
    $stmt->execute();

    echo "Registro guardado correctamente.";
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
