<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="https://quipusfact.site/fibranet/logo_fibra.png" sizes="48x48">
    <title>Dashboard - Transacciones Yape</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Custom CSS -->
    <link rel="stylesheet" href="css/styles.css">
</head>
<body>
    <div class="main-container">
        <!-- Header -->
        <div class="dashboard-header">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-8">
                        <h1 class="dashboard-title">
                            <i class="fas fa-credit-card me-2"></i>
                            Dashboard Transacciones
                        </h1>
                        <p class="dashboard-subtitle">Monitoreo en tiempo real de pagos Yape</p>
                    </div>
                    <div class="col-md-4">
                        <div class="header-info text-white text-end">
                            <div>
                                <i class="fas fa-clock me-1"></i>
                                <span id="current-time"></span>
                            </div>
                            <div class="mt-1">
                                <small>
                                    <i class="fas fa-sync-alt me-1"></i>
                                    <span id="last-update">Nunca</span>
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container">
            <!-- Stats Cards -->
            <div class="d-md-none">
                <!-- Móvil: 2x2 Grid -->
                <div class="stats-mobile-row fade-in">
                    <div class="stats-card">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #10b981, #059669);">
                            <i class="fas fa-money-bill-wave text-white"></i>
                        </div>
                        <div class="stats-number text-success" id="total-amount-mobile">S/ 0.00</div>
                        <div class="stats-label">Total</div>
                    </div>
                    <div class="stats-card">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #6366f1, #8b5cf6);">
                            <i class="fas fa-chart-line text-white"></i>
                        </div>
                        <div class="stats-number text-primary" id="total-transactions-mobile">0</div>
                        <div class="stats-label">Transacciones</div>
                    </div>
                </div>
                <div class="stats-mobile-row fade-in">
                    <div class="stats-card">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #f59e0b, #d97706);">
                            <i class="fas fa-calendar-day text-white"></i>
                        </div>
                        <div class="stats-number text-warning" id="today-transactions-mobile">0</div>
                        <div class="stats-label">Hoy</div>
                    </div>
                    <div class="stats-card">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #8b5cf6, #7c3aed);">
                            <i class="fas fa-users text-white"></i>
                        </div>
                        <div class="stats-number text-info" id="unique-users-mobile">0</div>
                        <div class="stats-label">Usuarios</div>
                    </div>
                </div>
            </div>

            <!-- Desktop Stats -->
            <div class="row mb-3 d-none d-md-flex">
                <div class="col-md-3 col-sm-6 mb-3">
                    <div class="stats-card fade-in">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #10b981, #059669);">
                            <i class="fas fa-money-bill-wave text-white"></i>
                        </div>
                        <div class="stats-number text-success" id="total-amount">S/ 0.00</div>
                        <div class="stats-label">Total Recaudado</div>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6 mb-3">
                    <div class="stats-card fade-in">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #6366f1, #8b5cf6);">
                            <i class="fas fa-chart-line text-white"></i>
                        </div>
                        <div class="stats-number text-primary" id="total-transactions">0</div>
                        <div class="stats-label">Transacciones</div>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6 mb-3">
                    <div class="stats-card fade-in">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #f59e0b, #d97706);">
                            <i class="fas fa-calendar-day text-white"></i>
                        </div>
                        <div class="stats-number text-warning" id="today-transactions">0</div>
                        <div class="stats-label">Hoy</div>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6 mb-3">
                    <div class="stats-card fade-in">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #8b5cf6, #7c3aed);">
                            <i class="fas fa-users text-white"></i>
                        </div>
                        <div class="stats-number text-info" id="unique-users">0</div>
                        <div class="stats-label">Usuarios &Uacute;nicos</div>
                    </div>
                </div>
            </div>

            <!-- Control Panel -->
            <div class="control-panel fade-in">
                <h2 class="section-title">
                    <i class="fas fa-tools me-2"></i>
                    Panel de Control
                </h2>
                <div class="mobile-actions">
                    <a href="exportar_excel.php" class="action-btn btn-download">
                        <i class="fas fa-download"></i>
                        Excel
                    </a>
                    <button class="action-btn btn-delete" onclick="limpiarTodasLasTransacciones()">
                        <i class="fas fa-trash-alt"></i>
                        Limpiar
                    </button>
                    <button id="boton-sonido" class="action-btn btn-sound">
                        <i class="fas fa-volume-up"></i>
                        Sonido
                    </button>
                    <button id="toggle-auto-update" class="action-btn btn-warning" onclick="toggleAutoUpdate()">
                        <i class="fas fa-pause"></i>
                        <span class="d-none d-md-inline">Auto-update</span>
                    </button>
                </div>
                <div class="text-center mt-2">
                    <button class="action-btn btn-secondary" onclick="cargarDatosDesdeServidor()">
                        <i class="fas fa-sync-alt"></i>
                        Actualizar
                    </button>
                </div>
            </div>

            <!-- Filtros -->
            <div class="control-panel fade-in">
                <button class="filter-toggle d-md-none" onclick="toggleFilters()">
                    <i class="fas fa-filter me-2"></i>
                    Filtros de B&uacute;squeda
                    <i class="fas fa-chevron-down float-end"></i>
                </button>
                
                <h2 class="section-title d-none d-md-block">
                    <i class="fas fa-filter me-2"></i>
                    Filtros de B&uacute;squeda
                </h2>
                
                <div class="filter-section" id="filter-section">
                    <div class="row">
                        <div class="col-md-3 mb-2">
                            <label for="nombre" class="form-label">
                                <i class="fas fa-user me-1"></i>
                                Nombre
                            </label>
                            <input type="text" id="nombre" class="form-control" 
                                   placeholder="Buscar..." oninput="aplicarFiltro()">
                        </div>
                        <div class="col-md-3 mb-2">
                            <label for="fecha" class="form-label">
                                <i class="fas fa-calendar me-1"></i>
                                Fecha
                            </label>
                            <input type="date" id="fecha" class="form-control" oninput="aplicarFiltro()">
                        </div>
                        <div class="col-md-3 mb-2">
                            <label for="monto-min" class="form-label">
                                <i class="fas fa-dollar-sign me-1"></i>
                                Monto M&iacute;n.
                            </label>
                            <input type="number" id="monto-min" class="form-control" 
                                   placeholder="0.00" step="0.01" oninput="aplicarFiltro()">
                        </div>
                        <div class="col-md-3 mb-2">
                            <label for="codigo-seguridad" class="form-label">
                                <i class="fas fa-key me-1"></i>
                                Código
                            </label>
                            <input type="text" id="codigo-seguridad" class="form-control" 
                                   placeholder="Código..." oninput="aplicarFiltro()">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <button class="btn btn-outline-secondary w-100" onclick="limpiarFiltros()">
                                <i class="fas fa-eraser me-1"></i>
                                Limpiar
                            </button>
                        </div>
                        <div class="col-md-6">
                            <div class="text-end mt-2 mt-md-0">
                                <small class="text-muted">
                                    <span id="resultados-count">0</span> resultados
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Vista Móvil - Cards -->
            <div class="table-mobile-view" id="mobile-transactions">
                <!-- Las transacciones se cargan aquí como cards -->
            </div>

            <!-- Vista Desktop - Tabla -->
            <div class="table-container table-desktop-view fade-in">
                <div class="loading-spinner" id="loading-spinner">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Cargando...</span>
                    </div>
                    <div class="mt-2">Cargando...</div>
                </div>
                
                <div class="responsive-table">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th style="width: 60px;">N°</th>
                                <th>Nombre</th>
                                <th>Pago</th>
                                <th>Monto</th>
                                <th>Código</th>
                                <th>Fecha</th>
                            </tr>
                        </thead>
                        <tbody id="tabla-datos">
                            <!-- Los datos se cargan aquí -->
                        </tbody>
                    </table>
                </div>

                <div class="empty-state" id="empty-state" style="display: none;">
                    <i class="fas fa-inbox"></i>
                    <h4>No hay transacciones</h4>
                    <p>No se encontraron transacciones.</p>
                </div>
            </div>

            <!-- Paginación -->
            <div class="pagination-container fade-in">
                <div class="pagination-info">
                    Mostrando <span id="pagination-showing">0</span> de <span id="pagination-total">0</span> transacciones
                </div>
                <div class="pagination-controls" id="pagination-controls">
                    <!-- Los controles de paginación se generan aquí -->
                </div>
            </div>
        </div>
    </div>

    <!-- Indicador de auto-actualización -->
    <div id="auto-update-indicator" class="auto-update-indicator">
        <i class="fas fa-sync-alt fa-spin me-1"></i>
        Actualizando...
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <!-- <script src="js/app.js"></script> -->
    <script src="js/scripts.js"></script>
    
</body>
</html>