<?php 
require 'vendor/autoload.php'; // Asegúrate de que Composer esté instalado

use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;
use Kreait\Firebase\Messaging\Notification;

// Datos de conexión a la base de datos
include 'config/bd.php';
try {
    // Conexión a la base de datos
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Obtener el último ID y los detalles completos (AHORA INCLUYE security_code)
    $stmt = $pdo->query("SELECT id, transaction_name, package_name, amount, security_code, date_time FROM transactions ORDER BY id DESC LIMIT 1");
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    // Comprobar si se obtuvo la fila correctamente
    if ($row) {
        // Detalles de la transacción
        $transactionName = $row['transaction_name'];
        $amount = $row['amount'];
        $securityCode = $row['security_code']; // NUEVO: Código de seguridad

        // Ruta al archivo JSON de la clave de servicio
        $serviceAccountPath = __DIR__ . '/fibranext-c5855-3f8447b899de.json';  // Asegúrate de que la ruta sea correcta

        // Inicializar Firebase con la clave JSON
        $factory = (new Factory)->withServiceAccount($serviceAccountPath);
        $messaging = $factory->createMessaging();

        // MEJORADO: Crear el mensaje con código de seguridad incluido
        $notificationTitle = 'Verificación de Pago Fibranet';
        $notificationBody = $transactionName . ' ha realizado un pago de S/ ' . $amount;
        
        // Agregar código de seguridad si existe
        if (!empty($securityCode)) {
            $notificationBody .= ' - Código: ' . $securityCode;
        }

        // Crear el mensaje de notificación con los datos completos de la transacción
        $message = CloudMessage::withTarget('topic', 'todos')
            ->withNotification(Notification::create(
                $notificationTitle,
                $notificationBody
            ));

        // Enviar la notificación
        try {
            $messaging->send($message);
            echo json_encode([
                "success" => true, 
                "message" => "Notificación enviada correctamente.",
                "transaction_data" => [
                    "name" => $transactionName,
                    "amount" => $amount,
                    "security_code" => $securityCode
                ]
            ]);
        } catch (Exception $e) {
            echo json_encode(["success" => false, "message" => "Error al enviar la notificación: " . $e->getMessage()]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "No se encontraron transacciones"]);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'error' => 'Error al conectar a la base de datos: ' . $e->getMessage()]);
}
?>